/**
 * 
 */
package gov.va.med.mhv.usermgmt.integration.service.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.apache.commons.lang.StringUtils;

import junit.framework.TestCase;

import gov.va.med.mhv.integration.registry.transfer.Gender;
import gov.va.med.mhv.integration.registry.transfer.Name;
import gov.va.med.mhv.integration.registry.transfer.PersonalInfo;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class RegistryInterfaceUtilsTest extends TestCase {

    public void testSetPersonalInfoWithNulls() throws Exception {
        Patient patient = TransferObjectFactory.createPatient();
        UserProfile userProfile = TransferObjectFactory.createUserProfile(); 
        patient.setUserProfile(userProfile);
        PersonalInfo personalInfo = createPersonalInfo(null, null, null,
            null, null, null);
        RegistryInterfaceUtils.setPersonalInfo(patient, personalInfo);
        assertEquals(personalInfo, userProfile);
    }

    public void testSetPersonalInfoWithValues() throws Exception {
        Patient patient = TransferObjectFactory.createPatient();
        UserProfile userProfile = TransferObjectFactory.createUserProfile(); 
        patient.setUserProfile(userProfile);
        PersonalInfo personalInfo = createPersonalInfo("Joe", "A.", "Veteran",
            "1/1/1970", "123-45-6789", GenderEnumeration.MALE);
        RegistryInterfaceUtils.setPersonalInfo(patient, personalInfo);
        assertEquals(personalInfo, userProfile);
    }

    public void testDescribePersonalInfoWithNull() throws Exception {
        PersonalInfo personalInfo = createPersonalInfo(null, null, null,
            null, null, null);
        String description = RegistryInterfaceUtils.describe(personalInfo);
        final String unknown = "unknown";
        assertContains(description, "Name: " + unknown);
        assertContains(description, "DOB: " + unknown);
        assertContains(description, "SSN: " + unknown);
        assertContains(description, "Gender: " + unknown);
    }
    
    public void testDescribePersonalInfoWithValues() throws Exception {
        PersonalInfo personalInfo = createPersonalInfo("Joe", "A.", "Veteran",
            "1/1/1970", "123-45-6789", GenderEnumeration.MALE);
        String description = RegistryInterfaceUtils.describe(personalInfo);
        assertContains(description, "Name: Veteran, Joe A.");
        assertContains(description, "DOB: 1-Jan-1970");
        assertContains(description, "SSN: ***-**-6789");
        assertContains(description, "Gender: Male");
    }

    private PersonalInfo createPersonalInfo(String firstName, 
        String middleName, String lastName, String dob, String ssn, 
        String gender) throws ParseException 
    {
        final SimpleDateFormat format = new SimpleDateFormat("MM/DD/yyyy");
        PersonalInfo personalInfo = new PersonalInfo();
        personalInfo.setName(new Name());
        personalInfo.getName().setFirstName(firstName);
        personalInfo.getName().setMiddleName(middleName);
        personalInfo.getName().setLastName(lastName);
        personalInfo.setDateOfBirth((dob != null) ? format.parse(dob) : null);
        personalInfo.setSsn(ssn);
        personalInfo.setGender(Gender.find(gender));
        return personalInfo;
    }
    
    private void assertEquals(PersonalInfo personalInfo, 
        UserProfile userProfile)
    {
        assertNotNull(personalInfo);
        assertNotNull(userProfile);
        assertEquals(personalInfo.getName().getFirstName(), userProfile.
            getFirstName());
        assertEquals(personalInfo.getName().getMiddleName(), userProfile.
            getMiddleName());
        assertEquals(personalInfo.getName().getLastName(), userProfile.
            getLastName());
        assertEquals(personalInfo.getSsn(), userProfile.getSsn());
        assertEquals(personalInfo.getDateOfBirth(), userProfile.getBirthDate());
        assertEquals((personalInfo.getGender() != null) ? personalInfo.
        	getGender().getName() : null, (userProfile.getGender() != null) 
        	? userProfile.getGender().getName(): null);
    }
    
    private void assertContains(String value, String substring) {
        assertNotNull("substring must be unequal to null", substring);
        assertTrue("String [" + value + "] does not contain substring [" + 
            substring + "]", StringUtils.contains(value, substring));
    }

}
